
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __ICENOTIFSYSTEM_H__
#define __ICENOTIFSYSTEM_H__

	typedef void (*NOTIF_CALLBACK)(udword owner, udword param, udword userdata);

	class ICECORE_API NotifSystem
	{
		public:
		// Constructor/Destructor
										NotifSystem();
										~NotifSystem();

						bool			AddNotif(udword owner, udword ref, NOTIF_CALLBACK callback, udword userdata);
						bool			RemoveNotif(udword owner, udword ref, NOTIF_CALLBACK callback=null);
						bool			RemoveNotif(udword owner);
						bool			ExecNotif(udword ref, udword param);
						bool			ExecNotif(udword owner, udword ref, udword param);

						udword			GetUsedRam();

						PREVENT_COPY(NotifSystem)
		private:
						udword			mFlags;					//!< System flags

						udword			mMaxNbNotifs;			//!< Number of dwords allocated in mOwners & mRefs
						udword			mCurNbNotifs;			//!< Number of used entries

						udword*			mOwners;				//!< List of owners
						udword*			mRefs;					//!< List of references
						NOTIF_CALLBACK*	mCallbacks;				//!< List of callbacks
						udword*			mUserData;				//!< List of user-defined data

						udword*			mSortedRefs;			//!< List of sorted references
						udword*			mRefsOffsets;			//!< Radix-like offsets for references
						udword			mMinRef;				//!< Smallest reference index
						udword			mMaxRef;				//!< Largest reference index

		// Internal methods
						udword			GetNbOwners(udword ref);
						bool			CreateOffsets();
						bool			PurgeList(const Container& killed);
	};

#endif // __ICENOTIFSYSTEM_H__
